 ; Ŀ
 ;   Datt - drawing name, date, and operator block updater.                
 ;   Copyright 1995, 1999, 2001, 2005 - 2010 by Rocket Software Ltd.       
 ;   When you can't remember what day it is, or who you are...             
 ;                                                                         
 ;   Note: there are two different Qdatt insert methods used in this       
 ;   program, the new Fishsh\Spoho method, and the older method which      
 ;   uses in-line code, which I didn't replace because it works.           
 ;   Keep this in mind when updating.                                      
 ;   Note 2: Fields in strings mess with the justification, so it is       
 ;   currently wise to use the left justified Rdatt block.                 
 ; 

 ; Ŀ
 ;   Dbtt - update existing blocks only.                                   
 ; 
 (DEFUN C:DBTT ()
  (datt)
  (setq dbttrun t)
 (princ))

 ; Ŀ
 ;   Roggle - toggle the attribute justification in Qdatt right/left.      
 ;   This is a hidden utility, not a subroutine.                           
 ; 
 (DEFUN C:ROGGLE (/ enam entt just ten new10 dist angl new11 nu11)
  (if (and (setq enam (car (entsel "Select Qdatt block: ")))
           (setq entt (entget enam))
           (member (strcase (cdr (assoc 2 entt)) t) '("qdatt" "rdatt"))
           (setq enam (entnext enam))
           (setq entt (entget enam))
           (setq just (cdr (assoc 72 entt))))
      (cond ((= just 0)                           ; left = 0, right = 2
             (setq ten (cdr (assoc 10 entt)))     ; starting 10 pos
             (entmod (subst (cons 72 2) (assoc 72 entt) entt))    ; change
             (setq entt (entget enam))            ; get the changed edata
             (setq new10 (cdr (assoc 10 entt)))   ; new 10 point
             (setq dist (distance ten new10))     ; distance moved
             (setq angl (angle new10 ten))        ; and angle
             (setq new11 (cdr (assoc 11 entt)))   ; new centre point
             (setq nu11 (polar new11 angl dist))  ; move centre as 10 was
             (entmod (subst (cons 11 nu11) (assoc 11 entt) entt))
             (prompt "\nAttribute Right Rejustified."))
            ((= just 2)                           ; right
             (entmod (subst (cons 72 0) (assoc 72 entt) entt))
             (prompt "\nAttribute Left Rejustified."))
            (T (prompt "Impossible Justification.")))
      (prompt "\n*Wrong*"))
 (princ))
 ; Ŀ
 ;   C:Roggle end.                                                         
 ; 

 ; Ŀ
 ;   Roggle - subroutine version - toggle the attribute justification      
 ;   in a Qdatt or Rdatt insert right/left.                                
 ;   Arguments: Enam, a block insertion entity name.                       
 ;              Justa, a desired justification, "left" or "right".         
 ; 
 (DEFUN ROGGLE (enam justa / entt just ten new10 dist angl new11 nu11)
  (setq enam (entnext enam))
  (setq entt (entget enam))
  (setq just (cdr (assoc 72 entt)))
  (cond ((and (= just 0) (= justa "right"))   ; left = 0, right = 2
         (setq ten (cdr (assoc 10 entt)))     ; starting 10 pos
         (entmod (subst (cons 72 2) (assoc 72 entt) entt))    ; change
         (setq entt (entget enam))            ; get the changed edata
         (setq new10 (cdr (assoc 10 entt)))   ; new 10 point
         (setq dist (distance ten new10))     ; distance moved
         (setq angl (angle new10 ten))        ; and angle
         (setq new11 (cdr (assoc 11 entt)))   ; new centre point
         (setq nu11 (polar new11 angl dist))  ; move centre as 10 was
         (entmod (subst (cons 11 nu11) (assoc 11 entt) entt))
         (prompt "\nAttribute Right Rejustified."))
        ((and (= just 2) (= justa "left"))    ; right
         (entmod (subst (cons 72 0) (assoc 72 entt) entt))
         (prompt "\nAttribute Left Rejustified."))
        (T (prompt "Impossible Justification.")))
 (princ))
 ; Ŀ
 ;   Subroutine Roggle end.                                                
 ; 

 ; Ŀ
 ;   Btx - update a text string in a block if it is the only subentity.    
 ;   Arguments: Blnam, a block name.                                       
 ;              Nustr, the new text string.                                
 ;   Returns T if the block was the right kind.                            
 ; 
 (DEFUN BTX (blnam nustr / blok namm entt ok)
  (if (and (setq blok (tblsearch "block" blnam))  ; head entity from table
           (setq namm (cdr (assoc -2 blok)))      ; first ename after head
           (setq entt (entget namm))              ; the whole thing
           (= (cdr (assoc 0 entt)) "TEXT")        ; if it's text
           (null (entnext namm)))                 ; and there's no next entity
      (progn
           (entmod (setq entt (subst (cons 1 nustr) (assoc 1 entt) entt)))
           (command ".regen")
           (setq ok t)))
 ok)
 ; Ŀ
 ;   Btx end.                                                              
 ; 

 ; Ŀ
 ;   Chug - string substitution engine.  Takes the search string, the      
 ;   replacement string, and the target string as arguments, and returns   
 ;   a list of the (possibly modified) target string and the number of     
 ;   changes made.                                                         
 ; 
 (DEFUN CHUG (oldstr newstr exstr / pos chnum changd newlen oldlen chunk)
  (setq pos 1)
  (setq chnum 0)
  (setq changd ())
  (setq newlen (strlen newstr))
  (setq oldlen (strlen oldstr))
  (while (= oldlen (strlen (setq chunk (substr exstr pos oldlen))))
         (if (= chunk oldstr)
             (progn
                  (setq exstr (strcat (substr exstr 1 (1- pos))
                                       newstr
                                      (substr exstr (+ pos oldlen))))
                  (setq changd t)
                  (setq chnum (1+ chnum))
                  (setq pos (+ pos newlen)))
             (setq pos (1+ pos))))
 (list exstr chnum))
 ; Ŀ
 ;   Chug end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Dast - make the drawing data string.                       
 ;   Brooks no arguments.                                                  
 ; 
 (DEFUN DAST (/ dd yy date hourp mins hour ampm name pref unam)
 ; Ŀ
 ;   Make the date string.                                                 
 ; 
;  (setq dd (rtos (getvar "cdate") 2 0))
;  (setq yy (substr dd 1 4) mm (substr dd 5 2) da (substr dd 7 2))
;  (setq dd (strcat yy "." mm "." da))
;  (setq date (rtos (getvar "cdate") 2 12))
;  (setq hourp (read (substr date 10 2)))
;  (setq mins (substr date 12 2))
;  (if (> hourp 12)
;      (setq hour (itoa (- hourp 12)))
;      (setq hour (itoa hourp)))
;  (if (and (>= hourp 12)
;           (> (read mins) 0))
;      (setq ampm "pm")
;      (setq ampm "am"))
;  (setq dd (strcat  dd " " hour ":" mins ampm))
 ; Ŀ
 ;   Try the new method: insert a field instead.                           
 ;   This should probably be disabled for old versions.                    
 ; 
  (setq dd "%<\\AcVar PlotDate \\f \"%#c\">%")
 ; Ŀ
 ;   Make the drawing name and path string.                                
 ; 
  (setq name (getvar "dwgname"))
  (setq pref (getvar "dwgprefix"))
  (setq name (strcase (strcat pref name)))
 ; Ŀ
 ;   If the current text style is based on the Rocket.shx font then        
 ;   modify the backslashes.                                               
 ; 
  (if (= "ROCKET.SHX" (strcase (cdr (assoc 3 (tblsearch "style" "standard")))))
      (setq name (car (chug "\\" "%%002" name))))
 ; Ŀ
 ;   Make something like the user initials.                                
 ;   Check the list for pseudo-initials for those who don't follow the     
 ;   pattern, if none are found then use the default.                      
 ; 
  (setq usrlst '(("ADAM" "Ngngngng")
                 ("ALONZO GONDINI" "SW")
                 ("BATESTR" "The Amazing Trent")
                 ("CAD3" "DeB")
                 ("CARNAHAN" "Ryan")
                 ("GHENKE" "The Metal Messiah")
                 ("JOHN BIOWAR" "SW")
                 ("JTAYLOR" "JET")
                 ("KDEBRUYN" "Chuck")
                 ("MIGGLESDEN" "Balthazar")
                 ("LWONG" "N-Gauge")
                 ("MPATON" "The General")
                 ("NSZCZEPANIUAK" "Fiona")
                 ("PINOCHETD" "DP")
                 ("PINOCHET" "DP")
                 ("RLEE" "Von Petch")
                 ("SWHITE" "Siyamon")
                 ("WBOYDE" "The Coach")
                 ("MGRAVES" "MWG")))
  (setq unam (strcase (getvar "loginname")))
  (if (setq unamp (assoc unam usrlst))
      (setq unam (cadr unamp))
      (setq unam (substr unam 1 2)))
 ; Ŀ
 ;   And concoct a final data string.                                      
 ; 
 (strcat "Plot Date: " dd "   File Name: " name "   By: " unam))
 ; Ŀ
 ;   Dast end.                                                             
 ; 

 ; Ŀ
 ;   Datt - update existing data blocks.                                   
 ; 
 (DEFUN DATT (/ ss found)
 ; Ŀ
 ;   If there is a plotdate block in the drawing update it.                
 ;   The Plotdate block (no origin known) has a text string which must     
 ;   be updated in the block definition rather than an attribute,          
 ;   apparently to make it difficult to use...                             
 ;   There may be more than one type of file data block in the drawing,    
 ;   so this isn't part of the if structure.                               
 ; 
  (btx "plotdate" (dast))
 ; Ŀ
 ;   If there is a data block in the drawing, update it.                   
 ;   Note that Updatt takes an ss rather than a single name as an          
 ;   just in case someone has seen fit to insert multiple data blocks.     
 ; 
  (setq found t)
  (if (or (and (or (tblsearch "block" "qdatt")
                   (tblsearch "block" "rdatt"))
               (setq ss (ssget "X" '((2 . "Qdatt,Rdatt") (66 . 1)))))
          (and (tblsearch "block" "bord_a1")
               (setq ss (ssget "X" '((2 . "bord_a1") (66 . 1)))))
          (and (tblsearch "block" "border")
               (setq ss (ssget "X" '((2 . "border") (66 . 1)))))
          (and (tblsearch "block" "Cadref")
               (setq ss (ssget "X" '((2 . "Cadref") (66 . 1)))))
          (and (or (tblsearch "block" "nclttld")
                   (tblsearch "block" "nclttld1"))
               (setq ss (ssget "X" '((2 . "nclttld,nclttld1") (66 . 1)))))
          (and (tblsearch "block" "tcmtb")
               (setq ss (ssget "X" '((2 . "tcmtb") (66 . 1)))))
          (and (tblsearch "block" "Marathontb")
               (setq ss (ssget "X" '((2 . "Marathontb") (66 . 1)))))
          (and (tblsearch "block" "Colleauxtb")
               (setq ss (ssget "X" '((2 . "Colleauxtb") (66 . 1)))))
          (and (tblsearch "block" "shawn")
               (setq ss (ssget "X" '((2 . "shawn") (66 . 1)))))
          (and (tblsearch "block" "RWTitleblock")
               (setq ss (ssget "X" '((2 . "RWTitleblock") (66 . 1)))))
          (and (tblsearch "block" "PEL D Size(Color)")
               (setq ss (ssget "X" '((2 . "PEL D Size(Color)") (66 . 1)))))
          (and (tblsearch "block" "PEL D Size")
               (setq ss (ssget "X" '((2 . "PEL D Size") (66 . 1)))))
          (and (tblsearch "block" "New PEL D Size")
               (setq ss (ssget "X" '((2 . "New PEL D Size") (66 . 1)))))
          (and (tblsearch "block" "Provident TB D Size")
               (setq ss (ssget "X" '((2 . "Provident TB D Size") (66 . 1))))))
      (updatt ss (dast))
      (setq found nil))
 found)
 ; Ŀ
 ;   Subroutine Datt end.                                                  
 ; 

 ; Ŀ
 ;   Fishsh - find a block or blocks, insert another block nearby.         
 ;   Arguments: Styl, the position insertion style for Spoho.              
 ;              Blnam, a block name (the one to find).                     
 ;              Othnam, another block name (the one to insert).            
 ;              Ofx, an X offset or offset distance, see Spoho.            
 ;              Ofy, a Y offset or rotation, See Spoho.                    
 ;              Bscal, the scale of the block to insert.                   
 ;              Rotax, the rotation of the block to insert.                
 ;              Laya, a layer name, if nil use the block layer.            
 ;   Calls Spoho.                                                          
 ;   Returns T if anything was found, else nil.                            
 ; 
 (DEFUN FISHSH (styl blnam othnam ofx ofy bscal rotax laya gnustr / ss num tab1
                                                           enam entt ctab layy)
  (if (and (tblsearch "block" blnam)
           (setq ss (ssget "x" (list (cons 2 blnam)))))
      (progn
           (setq num 0)
           (setq tab1 (getvar "ctab"))
           (while (setq enam (ssname ss num))
                  (setq num (1+ num))
                  (setq entt (entget enam))
                  (if laya
                      (setq layy laya)
                      (setq layy (cdr (assoc 8 entt))))
 ; Ŀ
 ;   See which space each title block occupies, go to that space.          
 ; 
                  (setvar "ctab" (setq ctab (cdr (assoc 410 entt))))
                  (if (/= (strcase ctab t) "model")
                      (command ".pspace"))
                  (setvar "clayer" layy)
                  (spoho styl enam othnam ofx ofy bscal rotax nil gnustr))
           (setvar "ctab" tab1)))
 (if ctab t ()))
 ; Ŀ
 ;   Fishsh end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Newdat: Inserts a Qdatt block if a known Tb is found.      
 ;   Arguments: Gnustr, the string for the new block.                      
 ;   Returns T if things went well, Nil if beset by nihilism.              
 ; 
 (DEFUN NEWDAT (gnustr / attd ss enam bent bnam scal pa rota rotinc po lave
                                                                  dsxp dsyp)
  (setq attd (getvar "attdia"))
 ; Ŀ
 ;   Fishsh arguments:                                                     
 ;     Styl, the position insertion style for Spoho.                       
 ;           A = x,y; B = angle, distance.                                 
 ;     Blnam, a block name (the one to find).                              
 ;     Othnam, another block name (the one to insert).                     
 ;     If Style is A: Xoff, the X offset from the block insertion point.   
 ;                    Yoff, the Y offset.                                  
 ;     If Style is B: Xoff, the distance from the block insertion point.   
 ;                    Yoff, rotation.                                      
 ;     Bscal, the scale of the block to insert.                            
 ;     Rotax, the rotation of the block to insert.                         
 ;     Laya, a layer name, if nil use the block layer.                     
 ;     Xrefp, T if the block is to xrefed, nil if inserted.                
 ;     Gnustr, the string for the first attribute.                         
 ; 
 ; Ŀ
 ;   Paramount: Paramount_ENG3_tb.                                         
 ; 
  (cond ((fishsh "A" "paramount_ENG3_tb" "rdatt" 4 11.5 1 90 nil gnustr))
 ; Ŀ
 ;   Pembina.                                                              
 ; 
        ((fishsh "B" "ppc-dsize" "rdatt" 6 99.5 1 90 nil gnustr))
 ; Ŀ
 ;   Enerplus.                                                             
 ; 
        ((fishsh "A" "erc-a1tb" "rdatt" 12.5 15 1 90 nil gnustr))
        ((fishsh "A" "ect-a1tb" "rdatt" 12.5 15 1 90 nil gnustr))
 ; Ŀ
 ;   The Snowdon Consulting tb.                                            
 ; 
        ((fishsh "B" "Snow-tb" "qdatt" 567.52 89.55 1 90 nil gnustr))
 ; Ŀ
 ;   Tridyne - the newest Tridyne_tb_d.  And maybe others.                 
 ;   Note that we are already into title block creep.                      
 ; 
        ((and (tblsearch "block" "Tridyne_TB_D")
              (setq ss (ssget "x" (list (cons 2 "Tridyne_TB_D")))))
         (setq enam (ssname ss 0))
         (if (= (tato enam) 81)
             (fishsh "A" "Tridyne_TB_D" "qdatt" 27 547 1 90 nil gnustr)
             (fishsh "A" "Tridyne_TB_D" "rdatt" -2 -0.5 1 90 nil gnustr)))
 ; Ŀ
 ;   Another new Tridyne tb - Tridyne_tb_d_coord.                          
 ; 
        ((and (tblsearch "block" "Tridyne_TB_D_Coord")
              (setq ss (ssget "x" (list (cons 2 "Tridyne_TB_D_Coord")))))
         (fishsh "A" "Tridyne_TB_D_Coord" "rdatt" -7 -0.5 1 90 nil gnustr))
 ; Ŀ
 ;   The new Upside electrical tb.                                         
 ; 
        ((fishsh "B" "D-BORD-E" "qdatt" 549.26314 88.22638 1 90 nil gnustr))
 ; Ŀ
 ;   CNRL Horizon.                                                         
 ;   This tb is inserted at a scale of 1000, so be careful.                
 ; 
        ((fishsh "A" "HORZ_2DbordA1" "rdatt" 0.0075 0.005 0.001 90 nil gnustr))
;       ((fishsh "A" "HORZ_2DbordA1" "qdatt" 0.005 0.555 0.001 90 nil gnustr))
 ; Ŀ
 ;   Sherritt - Titl-d2.                                                   
 ; 
        ((fishsh "A" "TITL-D2" "qdatt" 837 -5 1 0 nil gnustr))
 ; Ŀ
 ;   TransCanada - TB_Bor_a1VP.                                            
 ; 
        ((fishsh "A" "TB_Bor_a1VP" "rdatt" 19.1944 9.122 0.8 90 nil gnustr))
 ; Ŀ
 ;   Apparently Meg Worley - GLE-D.                                        
 ; 
        ((fishsh "A" "GLE-D" "qdatt" 837 -5 1 0 nil gnustr))
 ; Ŀ
 ;   Another Upside tb.                                                    
 ; 
        ((and (tblsearch "block" "TITBLK-D_METRIC")
              (setq ss (ssget "X" (list (cons 2 "TITBLK-D_METRIC")))))
         (setq bent (entget (setq bnam (ssname ss 0))))
         (setq scal (cdr (assoc 41 bent)))
         (setq pa (cdr (assoc 10 bent)))
         (setq rota (cdr (assoc 50 bent)))
         (setq rotinc (/ (* pi 86.96245) 180))
         (setq po (polar pa (+ rota rotinc) (* scal 547.2689)))
         (setq rota (* (/ rota pi) 180))
         (setq lave (getvar "clayer"))
         (setvar "clayer" (cdr (assoc 8 bent)))
         (setvar "attdia" 0)
         (command "insert" "qdatt" po scal "" (+ rota 90) "")
         (setvar "attdia" attd)
         (setvar "clayer" lave))
 ; Ŀ
 ;   Yet another in an almost infinite variety of Upside title blocks.     
 ; 
        ((and (tblsearch "block" "TITBLK-B")
              (setq ss (ssget "X" (list (cons 2 "TITBLK-B")))))
         (setq bent (entget (setq bnam (ssname ss 0))))
         (setq scal (cdr (assoc 41 bent)))
         (setq pa (cdr (assoc 10 bent)))
         (setq rota (cdr (assoc 50 bent)))
         (setq rotinc (/ (* pi 87.2301) 180))
         (setq po (polar pa (+ rota rotinc) (* scal 11.26315)))
         (setq rota (* (/ rota pi) 180))
         (setq lave (getvar "clayer"))
         (setvar "clayer" (cdr (assoc 8 bent)))
         (setvar "attdia" 0)
         (command "insert" "qdatt" po (* scal 0.032) "" (+ rota 90) "")
         (setvar "attdia" attd)
         (setvar "clayer" lave))
 ; Ŀ
 ;   This one is an AEC tb, but there are four known ones.                 
 ;   So bear this in mind if we ever get any more AEC work.                
 ; 
        ((and (tblsearch "block" "ignore-TITBLK-B") ; don't use
              (setq ss (ssget "X" (list (cons 2 "ignore-TITLEBLK")))))
         (setq bent (entget (setq bnam (ssname ss 0))))
         (setq scal (cdr (assoc 41 bent)))
         (setq pa (cdr (assoc 10 bent)))
         (setq rota (cdr (assoc 50 bent)))
         (setq rotinc (/ (* pi 145.8023) 180))
         (setq po (polar pa (+ rota rotinc) (* scal 951.2616)))
         (setq rota (* (/ rota pi) 180))
         (setq lave (getvar "clayer"))
         (setvar "clayer" (cdr (assoc 8 bent)))
         (setvar "attdia" 0)
         (command "insert" "qdatt" po scal "" (+ rota 90) "")
         (setvar "attdia" attd)
         (setvar "clayer" lave))
        ((and (tblsearch "block" "DTEXT-M")
              (setq ss (ssget "X" (list (cons 2 "DTEXT-M")))))
         (setq bent (entget (setq bnam (ssname ss 0))))
         (setq scal (cdr (assoc 41 bent)))
         (setq pa (cdr (assoc 10 bent)))
         (setq rota (cdr (assoc 50 bent)))
         (setq po (polar pa (+ rota 1.55544) (* scal 522.312)))
         (setq rota (* (/ rota pi) 180))
         (setq lave (getvar "clayer"))
         (setvar "clayer" (cdr (assoc 8 bent)))
         (setvar "attdia" 0)
         (command "insert" "qdatt" po scal "" (+ rota 90) "")
         (setvar "attdia" attd)
         (setvar "clayer" lave))
 ; Ŀ
 ;   The original Gemini tb.                                               
 ; 
        ((and (tblsearch "block" "GELTITLE")
              (setq ss (ssget "X" (list (cons 2 "GELTITLE")))))
         (setq bent (entget (setq bnam (ssname ss 0))))
         (setq scal (cdr (assoc 41 bent)))
         (setq pa (cdr (assoc 10 bent)))
         (setq rota (cdr (assoc 50 bent)))
         (setq rotinc (/ (* pi 89.49297094) 180))
         (setq po (polar pa (+ rota rotinc) (* scal 565.02212346)))
         (setq rota (* (/ rota pi) 180))
         (setq lave (getvar "clayer"))
         (setvar "clayer" (cdr (assoc 8 bent)))
         (setvar "attdia" 0)
         (command "insert" "qdatt" po scal "" (+ rota 90) "")
         (setvar "attdia" attd)
         (setvar "clayer" lave))
 ; Ŀ
 ;   The relatively new Gemini electrical tb.                              
 ; 
        ((and (tblsearch "block" "GEIELCTB")
              (setq ss (ssget "X" (list (cons 2 "GEIELCTB")))))
         (setq bent (entget (setq bnam (ssname ss 0))))
         (setq scal (cdr (assoc 41 bent)))
         (setq pa (cdr (assoc 10 bent)))
         (setq rota (cdr (assoc 50 bent)))
         (setq dsxp (+ (car pa) (* 5 scal)))
         (setq dsyp (+ (cadr pa) (* 565 scal)))
         (setq lave (getvar "clayer"))
         (setvar "clayer" (cdr (assoc 8 bent)))
         (setvar "attdia" 0)
         (command "insert" "qdatt" (list dsxp dsyp) scal "" "90" "")
         (setvar "attdia" attd)
         (setvar "clayer" lave)))
 (if ss t ()))
 ; Ŀ
 ;   Newdat end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Splat - divide a text string into a list of substrings.    
 ;   Arguments: Sepchr, the field separator character.                     
 ;              Linn, the text string.                                     
 ;   Returns a list of field values, removes leading and trailing spaces.  
 ; 
 (DEFUN SPLAT (sepchr linn / len pos name1 strlst)
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (= (substr linn (setq len (strlen linn))) " ")
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) sepchr)
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (while (= (substr name1 (setq len (strlen name1))) " ")
                (setq name1 (substr name1 1 (1- len))))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Splat end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Spoho - install a block in a position expressed as an      
 ;   offset from the insertion point of another block and at a matching    
 ;   scale.  Got that?                                                     
 ;   Arguments: Styl, the style of offset to use, A or B.                  
 ;              Enam, the main (typically tb) block ename.                 
 ;              Blnam, the name of the block to insert.                    
 ;              If Style is A:                                             
 ;                   Xoff, the X offset from the block insertion point.    
 ;                   Yoff, the Y offset.                                   
 ;              If Style is B:                                             
 ;                   Xoff, the distance from the block insertion point.    
 ;                   Yoff, rotation.                                       
 ;              Bscal, the block scale relative to the tb scale.           
 ;              Rotax, the block rotation relative to the tb rotation.     
 ;              Xrefp, T if the block is to xrefed, nil if inserted.       
 ;              Gnustr, the string for the first attribute.                
 ;   Does nothing if the block name is nil.                                
 ;   Returns nothing, calls your mama.                                     
 ;   This is a variation of Spoosh, which installs text directly rather    
 ;   than from an attribute prompt, and thus won't screw up a script.      
 ; 
 (DEFUN SPOHO (styl enam blnam xoff yoff bscal rotax xrefp gnustr / osna dsxp
                                    attrq angg dist dsyp entt brota pa pb ds)
  (setq osna (getvar "osmode"))
  (setvar "osmode" 0) 
  (setq attrq (getvar "attreq"))
  (if blnam
      (progn
           (setq entt (entget enam))
           (setq pa (cdr (assoc 10 entt)))
           (setq brota (cdr (assoc 50 entt)))
           (if (null brota) (setq brota 0))
           (setq rotax (+ rotax (* (/ 180 pi) brota)))
           (setq ds (cdr (assoc 41 entt)))
           (setq bscal (* ds bscal))
           (cond ((= styl "A")
                  (setq dsxp (+ (car pa) (* xoff ds)))
                  (setq dsyp (+ (cadr pa) (* yoff ds)))
                  (setq pb (list dsxp dsyp))
                  (setq angg (angle pa pb))
                  (setq dist (distance pa pb))
                  (setq angg (+ angg brota))
                  (setq pb (polar pa angg dist)))
                 ((= styl "B")
                  (setq yoff (* (/ pi 180) yoff))
                  (setq pb (polar pa (+ brota yoff) (* ds xoff)))))
           (cond ((equal bscal 0 0.000000001)
                  (prompt
            "No Data block inserted - TB Scale is perilously close to 0."))
                 (xrefp
                  (command ".-xref" "attach" blnam pb bscal "" rotax))
                 ((findfile (strcat blnam ".dwg"))
                  (setvar "attreq" 0)
                  (command ".insert" (strcat blnam "=") pb bscal "" rotax)
                  (setvar "attreq" attrq)
                  (updab (entlast) gnustr))
                 ((tblsearch "block" blnam)
                  (prompt (strcat "External file for "
                                   blnam " not found.  "
                                  "Using the definition in the drawing."))
                  (setvar "attreq" 0)
                  (command ".insert" blnam pb bscal "" rotax)
                  (setvar "attreq" attrq)
                  (updab (entlast) gnustr)))))
  (setvar "osmode" osna)
 (princ))
 ; Ŀ
 ;   Subroutine Spoho end.                                                 
 ; 

 ; Ŀ
 ;   Tato - count the attributes in a block insertion.                     
 ;   (The insertion and the definition may be different, this way we get   
 ;   what we have rather than what we might have - if the block has been   
 ;   redefined, which isn't that unlikely when there are two title blocks  
 ;   with the same name - then we need to go with the insertion because    
 ;   the attributes won't have changed...although neither way really makes 
 ;   much sense...                                                         
 ;   Arguments: Enam, a block insertion entity name.                       
 ;   Returns a number.                                                     
 ; 
 (DEFUN TATO (enam / num)
  (setq num 0)
  (while (/= "SEQEND" (cdr (assoc 0 (entget (setq enam (entnext enam))))))
         (setq num (1+ num)))
 num)
 ; Ŀ
 ;   Tato end.                                                             
 ; 

 ; Ŀ
 ;   Updab - replace the first attribute value in a block insertion.       
 ;   Arguments: Enam, a block insertion entity name.                       
 ;              Stra, a string.                                            
 ;   Calls nothing, returns nothing.                                       
 ;   Makes sure that there is an attribute in case someone has screwed up. 
 ; 
 (DEFUN UPDAB (enam stra / entt)
  (setq entt (entget (entnext enam)))
  (if (= (cdr (assoc 0 entt)) "ATTRIB")
      (progn
           (entmod (subst (cons 1 stra) (assoc 1 entt) entt))
           (entupd enam)))
 (princ))
 ; Ŀ
 ;   Updab end.                                                            
 ; 

 ; Ŀ
 ;   Updatt - update all Qdatt data blocks.                                
 ;   That isn't strictly correct - it replaces a named attribute in each   
 ;   blocks in Ss with the string in Strall.                               
 ;   Takes two arguments: an ss of blocks and a data string.               
 ;   Returns a bottle of Schlobb: the first beer made from broccoli.       
 ; 
 (DEFUN UPDATT (ss strall / num enam entt esav tagg)
 ; Ŀ
 ;   Now (if ss exists) update the blocks.                                 
 ; 
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq esav enam)
         (setq num (1+ num))
         (while (/= (cdr (assoc 0 (setq entt (entget enam)))) "SEQEND")
                (setq tagg (cdr (assoc 2 entt)))
                (if (member tagg '("DWGDATA" "CADNUM" "PLOT_DATE"
                                   "FILE" "CAD_TAG"))
                    (entmod (subst (cons 1 strall) (assoc 1 entt) entt)))
                (setq enam (entnext enam)))
         (entupd esav))
 (princ))
 ; Ŀ
 ;   Updatt end.                                                           
 ; 

 ; Ŀ
 ;   Datt.                                                                 
 ; 
 (DEFUN C:DATT (/ ss *error* osmo attrq)
  (setvar "cmdecho" 0)
  (setq datrun t)
  (setq osmo (getvar "osmode"))
  (setq attrq (getvar "attreq"))
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (setvar "attreq" attrq)
   (setvar "osmode" osmo)
   (if shk (write-line shk))
  (princ))
 ; Ŀ
 ;   If there is a data block in the drawing then update it.               
 ; 
  (if (null (datt))
 ; Ŀ
 ;   If not then insert a Qdatt and update it.                             
 ;   Note that Newdat will only insert Qdatt if it finds a known Tb -      
 ;   random fragments will be left alone.                                  
 ; 
      (progn
           (setvar "osmode" 0)
           (newdat (dast))
           (setvar "osmode" osmo)))
  (*error* ())
 (princ))